# check_modules.py

import sys
import importlib
import subprocess
import re

def get_imported_modules_from_source(file_path):
    """
    Читает исходный файл и извлекает имена модулей из строк вида:
      import <module>
      from <module> import ...
    """
    modules = set()
    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            code = f.read()
    except Exception as e:
        print("Не удалось прочитать исходный файл для анализа импортов:", e)
        return modules

    for line in code.splitlines():
        line = line.strip()
        # Пропускаем комментарии
        if line.startswith("#"):
            continue
        # Убираем возможные комментарии в конце строки
        line = line.split("#")[0].strip()
        # Ищем строки импорта
        m = re.match(r'^(?:from|import)\s+([a-zA-Z0-9_]+)', line)
        if m:
            modules.add(m.group(1))
    return list(modules)

def install_missing_modules(modules):
    """Пытается установить недостающие модули через pip"""
    for module in modules:
        try:
            importlib.import_module(module)
        except ImportError:
            print(f"Модуль {module} не найден. Устанавливаем...")
            subprocess.check_call([sys.executable, "-m", "pip", "install", module])

def check_and_install_modules(file_path):
    """Читает файл и проверяет наличие всех необходимых модулей"""
    imported_modules = get_imported_modules_from_source(file_path)
    install_missing_modules(imported_modules)
